<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../classi/GeneratoreUrl.php";
    include "../gUtil/DbManager.php";
    include "../gUtil/ControlloreStringhe.php";
    include "../gUtil/Ricerca.php";
    include "../gUtil/GestoreTabella.php";
    include "../classi/Tabella.php";
    include "../classi/Api.php";
    
    session_start();
    controlloAccessoAdmin();
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb   = new DbManager($costantiDatabase);
    $impostazioni = recuperaImpostazioni($geecomDb);
    
    if(isset($_GET["operazione"])) {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $api  = new Api($geecomDb, filter_input(INPUT_GET, "id"));
    }
    else {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $api  = new Api($geecomDb, filter_input(INPUT_POST, "id"));
    }
    
    // dato che serve in molti switch per capire la pagina a cui l'utente deve essere rediretto
    $datiProdottoGeecom  = $geecomDb->leggiSingolaRiga("geec_prodotti", 1) ;
    $percorsoGeecomAdmin = GeneratoreUrl::creaUrlAreaAmministrativa($impostazioni,$datiProdottoGeecom);
    
    switch ($operazione) {
        case 'crea':
            $api->setAttiva("no");
            $api->setNomeUtenza(filter_input(INPUT_POST,"nomeUtenza",FILTER_SANITIZE_ADD_SLASHES));
            $api->setCodiceSegreto(filter_input(INPUT_POST,"codiceSegreto",FILTER_SANITIZE_STRING));
            $api->setPermessiLettura("no");
            $api->setPermessiScrittura("no");
            $api->crea();
            echo "ok";
            break;
        case 'modifica':
            $attiva = (isset($_POST["attiva"]) && $_POST["attiva"]=="si") ? "si" : "no";
            $permessiLettura   = (isset($_POST["permessiLettura"]) && $_POST["permessiLettura"]=="si") ? "si" : "no";
            $permessiScrittura = (isset($_POST["permessiScrittura"]) && $_POST["permessiScrittura"]=="si") ? "si" : "no";
            
            $api->setAttiva($attiva);
            $api->setNomeUtenza(filter_input(INPUT_POST,"nomeUtenza",FILTER_SANITIZE_ADD_SLASHES));
            $api->setCodiceSegreto(filter_input(INPUT_POST,"codiceSegreto",FILTER_SANITIZE_STRING));
            $api->setPermessiLettura($permessiLettura);
            $api->setPermessiScrittura($permessiScrittura);
            
            $api->modifica();
            echo "ok";
            break;
        case 'duplica':
            $idCategoriaDuplicata = $api->duplica();
            header("Location: $percorsoGeecomAdmin/creaCategoria.php?id=$idCategoriaDuplicata&status=210");
            break;
        case 'aggiornaPosizione':
            $api->caricaDatiDalDatabase();
            $nuovaPosizione = filter_input(INPUT_POST,"nuovaPosizione",FILTER_SANITIZE_NUMBER_INT);
            $api->aggiornaPosizione($nuovaPosizione);
            echo "ok";
            break;
        case 'recuperaFotoCategoria':
            $api->caricaDatiDalDatabase();
            echo ($api->getFoto()!="" ? "../".$api->getFoto() : "../immagini/altro/segnaposto.png");
            break;
        case 'cambiaImmagine':
            $tipiFileAmmessi = array("image/png","image/jpeg","image/gif");
            $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../immagini/categorie", 0, $api->getNome());
            $esitoUpload  = $gestoreUpload->salvaFile();
            if($esitoUpload["fileElaborati"]==1) {
                if($esitoUpload["percorso"]!="") {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                }
                // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                    $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                    if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                        $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                    }
                }
            }
            else {
                $percorsoFoto = "";
            }
            $api->cambiaImmagine($percorsoFoto);
            echo $percorsoFoto;
            break;
        case 'eliminaImmagine':
            $api->cambiaImmagine("");
            echo "ok";
            break;
        case 'elimina':
            $api->elimina();
            echo "ok";
            break;
        case 'stampaUtenzeApi':
            $elementiPerPagina = isset($_GET["elementiPerPagina"]) ? filter_input(INPUT_GET,"elementiPerPagina",FILTER_SANITIZE_NUMBER_INT) : 25;
            $cerca             = isset($_GET["cerca"]) ? filter_input(INPUT_GET,"cerca",FILTER_SANITIZE_STRING) : "";

            $parametri = array("tabella"=>"geec_utenzeApi", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>array(),"ajax"=>false);

            $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"impostazioni.php");
    
            if(isset($_GET["pag"])) {
                $ris = $ricerca->eseguiRicerca($_GET["pag"],"OR");
            }
            else {
                $ris = $ricerca->eseguiRicerca(1,"OR");
            }

            $colonne = array("ID","Utenza","Attiva","Codice segreto","Permessi","");
            $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);
            $tabella->setTipo("normale");
            while($utenzaApi = $ris->fetch_assoc()) {
                $nomeEscape = filter_var($utenzaApi["nomeUtenza"],FILTER_SANITIZE_ADD_SLASHES);

                $stringaPermessi ="";
                if($utenzaApi["permessiLettura"]=="si") {
                    $stringaPermessi = "lettura";
                }
                $stringaPermessi .= " - ";
                if($utenzaApi["permessiScrittura"]=="si") {
                    $stringaPermessi .= "scrittura";
                }

                $azioni = array("modifica"=>"javascript:void\" onclick=\"modificaUtenzaApi({$utenzaApi["id"]},'$nomeEscape','{$utenzaApi["codiceSegreto"]}','{$utenzaApi["attiva"]}','{$utenzaApi["permessiLettura"]}','{$utenzaApi["permessiScrittura"]}')","elimina"=>"apriPopupEliminaUtenzaApi({$utenzaApi["id"]},'{$nomeEscape}')");
                $tabella->aggiungiNuovaRiga(array($utenzaApi["id"],"<a href=\"javascript:void\" onclick=\"modificaUtenzaApi({$utenzaApi["id"]},'$nomeEscape','{$utenzaApi["codiceSegreto"]}','{$utenzaApi["attiva"]}','{$utenzaApi["permessiLettura"]}','{$utenzaApi["permessiScrittura"]}')\"><b>{$utenzaApi["nomeUtenza"]}</b></a>",$utenzaApi["attiva"],$utenzaApi["codiceSegreto"],$stringaPermessi), $azioni);
            }
            
            $tabella->stampa("utenzaApi",0);
            $ricerca->stampaPaginazione(true,"impsotazioni.php");
            break;
    }